#ifdef SKINNING

	uniform mat4 	boneMatrices[100],
			prevBoneMatrices[100];
//	attribute vec4  weights;
//	attribute vec4  matrixIndices;

#endif

#ifdef PSYSTEM

	uniform	vec4 	pparams[100]; /*,
					prevPParams[100];*/	

	vec4		tpos;
	uniform vec4	data;

	//attribute vec4	index;
	varying float 	life;

#endif

varying vec2 	texcoord;
uniform vec2	tscale0;

varying vec4 	curpos,
		pos, 
		prev;
uniform mat4	prevMVM,
		WTM;
vec2		tofs = vec2(0.0,0.0);		// cambiare in uniform
uniform vec2	NF;
		
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{
  
#ifdef SKINNING

	vec4 index  		= gl_SecondaryColor;//matrixIndices;
	vec4 weight 		= gl_Color;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 prevpos 		= vec4( 0.0, 0.0, 0.0, 0.0 );
	
	mat4 TM;

  	for( int i = 0; i < 4; i++ )
 	{
 	    // Apply influence of bone i
		TM=boneMatrices[int(index[i])];
  	    position = position + (TM * gl_Vertex) *weight[i];
		prevpos = prevpos + ((prevBoneMatrices[int(index[i])] * gl_Vertex) * weight[i]);
	}
	gl_Position = gl_ModelViewProjectionMatrix * position;
	prev = gl_ProjectionMatrix*prevMVM*prevpos;	
	pos = (gl_ModelViewMatrix * position);

#else

	#ifdef PSYSTEM

		vec4 ppos=pparams[/*index.x*/gl_Color.x];
		life=ppos.w;
		float scale=data.x + (data.y*(1.0-life));
		scale=clamp(scale,0.0,abs(scale))*0.5;
		scale+=scale*/*index.y*/gl_Color.y;	
		ppos.w=1.0;

		float angle=(/*index.y*/gl_Color.y*6.28)+(data.z*(1.0-life)*6.28);

		float cosa=cos(angle);
		float sina=sin(angle);

		tpos=gl_ModelViewMatrix * ppos;	

		vec3 tv=gl_Vertex;
		tv.x=(gl_Vertex.x*cosa)-(gl_Vertex.y*sina);
		tv.y=(gl_Vertex.x*sina)+(gl_Vertex.y*cosa);
		tpos.xyz=(tv.xyz*scale + tpos.xyz);

		gl_Position=gl_ProjectionMatrix*tpos;
		
		tofs=ComputeFrame(1.0-life, NF);
	/*
		ppos=prevPParams[index.x];
		life=ppos.w;
		float scale=data.x + (data.y*(1.0-life));
		scale=clamp(scale,0.0,abs(scale))*0.5;
		scale+=scale*index.y;	
		ppos.w=1.0;

		float angle=(index.y*6.28)+(data.z*(1.0-life)*6.28);

		float cosa=cos(angle);
		float sina=sin(angle);

		tpos=gl_ModelViewMatrix * ppos;	

		vec3 tv=gl_Vertex;
		tv.x=(gl_Vertex.x*cosa)-(gl_Vertex.y*sina);
		tv.y=(gl_Vertex.x*sina)+(gl_Vertex.y*cosa);
		tpos.xyz=(tv.xyz*scale + tpos.xyz);
		prev=gl_ProjectionMatrix * prevPPos;	
	*/
				
	#else

		gl_Position = ftransform();
		pos=(gl_ModelViewMatrix * gl_Vertex);
		mat4 MVP=gl_ProjectionMatrix*prevMVM*WTM;
		prev=MVP*gl_Vertex;

	#endif

#endif

	texcoord = gl_MultiTexCoord0.st*tscale0 + tofs;
	curpos=gl_Position;
}